/****************************************************************************************
*  All Rigft Reserved By Soliton Tech. 2015
*  File       PciTg2.h
*  Brief      Soliton PCI/PCIE TG DLL Header File
*  Version    1.01
*  Revision history:
*  -------------------------------------------------------------------------------------
*  Num.     When          Description
*  -------------------------------------------------------------------------------------
*  1.00     Jan/26/2015   Initial version
*  1.01     Feb/11/2015   Support PCIETG & PCITG2 
****************************************************************************************/

#ifndef __SOLITON_Pcitg2LIB64_h__
#define __SOLITON_Pcitg2LIB64_h__

#define PCITG2_SUCCESS				0
#define PCITG2_DEVICENOTFOUND		1
#define PCITG2_MEMREGNOTMAP			2

#ifdef PCITG2_EXPORTS
#define PCITG2_API __declspec(dllexport)
#else
#define PCITG2_API __declspec(dllimport)
#endif

#ifdef __cplusplus
extern "C" {
#endif
	PCITG2_API int __stdcall PciTg2_LibVersion(int *major, int *minor); 
	PCITG2_API int __stdcall PciTg2_open(int index);
	PCITG2_API int __stdcall PciTg2_close();
	PCITG2_API int __stdcall PciTg2_out(unsigned long offset, unsigned long data);
	PCITG2_API int __stdcall PciTg2_in(unsigned long offset);
	PCITG2_API int __stdcall PciTg2_srst();
	PCITG2_API int __stdcall PciTg2_enint();
	PCITG2_API int __stdcall PciTg2_disint();
	PCITG2_API int __stdcall PciTg2_ackint();
	PCITG2_API int __stdcall PciTg2_sts();
	PCITG2_API int __stdcall PciTg2_setwr2wrdly(double delay);

	PCITG2_API int __stdcall PciTg2_open2();
	PCITG2_API int __stdcall PciTg2_close2();
	PCITG2_API int __stdcall PciTg2_out2(int boardid, unsigned long offset, unsigned long data);
	PCITG2_API int __stdcall PciTg2_in2(int boardid, unsigned long offset);
	PCITG2_API int __stdcall PciTg2_getvalidid2(int *swid);



#ifdef __cplusplus
}
#endif
#endif
